/* NonVolatile.h */

#ifndef NON_VOLATILE_H
#define NON_VOLATILE_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include "CommonInclude.h"
#define NV_MAGIC_NUMBER                (39593U)

/*---- TYPEDEFS -------------------------------------------------------------------------------------------*/

/* Name: E_NVStatus ClassID:ENUMDEC EnumDflt:"Illegal" */
typedef enum {
  NV_LOADING_FACTORY,                  /* EnumTxt:"Currently loading NV from Factory FLASH to RAM" */
  NV_LOADING_EEPROM,                   /* EnumTxt:"Currently loading NV from EEPROM to RAM" */
  NV_STORING_EEPROM,                   /* EnumTxt:"Currently storing NV from RAM to EEPROM" */
  NV_LOADED_FACTORY_BAD_MAGIC,         /* EnumTxt:"Detected new program.  Loaded Factory Defaults from FLASH" */
  NV_LOADED_FACTORY_BAD_CRC,           /* EnumTxt:"CRC failure.  Loaded Factory Defaults from FLASH" */
  NV_LOADED_FACTORY_USER_CMD,          /* EnumTxt:"User requested refresh from Factory Defaults in FLASH." */
  NV_LOADED_EEPROM                     /* EnumTxt:"Successful refresh of EEPROM values from last shutdown" */
} E_NVStatus;

/* Name: E_NVRestore ClassID:ENUMDEC EnumDflt:"Illegal" */
typedef enum {
  NV_RESTORE_APP,                      /* EnumTxt:"Load saved application values on next startup" */
  NV_RESTORE_DEFAULTS,                 /* EnumTxt:"Load factory defaults on next startup" */
} E_NVRestore;

/* NonVolatile Namespace */
typedef struct {
  uint32_T NonVolatileFormatID;
  uint32_T crc;
  uint32_T MotoHawkModelSecondsInUse;
  uint8_T mh_CityID_CAN_1;
} NonVolatile_T;

/*---- FUNCTION DECLARATIONS ------------------------------------------------------------------------------*/
extern void RestoreDefaultNonVolatile(void);
extern void OpenNonVolatile(void);
extern void StoreNonVolatile(void);

/*---- CONSTANTS ------------------------------------------------------------------------------------------*/
extern const NonVolatile_T NonVolatileDefault;

/*---- EEPROM VARIABLES -----------------------------------------------------------------------------------*/
extern NonVolatile_T NonVolatileStorage;

/*---- RAM VARIABLES --------------------------------------------------------------------------------------*/
extern NonVolatile_T NonVolatileWork;
extern uint8_T NonVolatileStatus;

/*---- END OF FILE ----------------------------------------------------------------------------------------*/
#endif
